using MicroFour.StrataFrame.Business;
using MicroFour.StrataFrame.Security;
using MicroFour.StrataFrame.UI.Windows.Forms;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.IO;

namespace StrataFlix.Business
{
    public partial class MoviesBO
    {

        #region " Component Implementation "

        [System.Diagnostics.DebuggerNonUserCodeAttribute()]
        protected override void Dispose(bool disposing)
        {
            if (disposing && (this.components != null))
            {
                this.components.Dispose();
            }
            base.Dispose(disposing);
        }

        private System.ComponentModel.Container components = null;

        //NOTE: The following procedure is required by the Component Designer
        //It can be modified using the Component Designer.
        //Do not modify it using the code editor.
        [System.Diagnostics.DebuggerNonUserCodeAttribute()]
        private void InitializeComponent()
        {
            MicroFour.StrataFrame.Business.RequiredField RequiredField1 = new MicroFour.StrataFrame.Business.RequiredField();
            MicroFour.StrataFrame.Business.RequiredField RequiredField2 = new MicroFour.StrataFrame.Business.RequiredField();
            MicroFour.StrataFrame.Business.RequiredField RequiredField3 = new MicroFour.StrataFrame.Business.RequiredField();
            //
            //MoviesBO
            //
            RequiredField1.FieldName = "mv_Rating";
            RequiredField1.FieldType = @System.Data.SqlDbType.Variant;
            RequiredField2.FieldName = "mv_Title";
            RequiredField2.FieldType = System.Data.SqlDbType.Text;
            RequiredField3.FieldName = "mv_Year";
            RequiredField3.FieldType = System.Data.SqlDbType.Text;
            this.RequiredFields.AddRange(new MicroFour.StrataFrame.Business.RequiredField[] { RequiredField1, RequiredField2, RequiredField3 });

        }

        #endregion


        #region BusinessLayer Overriden Methods & Properties

        /// <summary>
        /// The collection of required fields for the business object.
        /// </summary>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override RequiredFieldsCollection RequiredFields
        {
            get
            {
                return base.RequiredFields;
            }
            set
            {
                base.RequiredFields = value;
            }
        }

        /// <summary>
        /// Defines the constraint that defines the parent-child relationship between this business object type and another business object type.
        /// </summary>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override IBusinessParentRelationship ParentRelationship
        {
            get
            {
                return base.ParentRelationship;
            }
            set
            {
                base.ParentRelationship = value;
            }
        }

        /// <summary>
        /// Returns all of the field names in a single string in the form of [field1],[field2],...  This must be used in the place of '*' in select statements if Query Notifications are to be registered.
        /// </summary>
        protected override String AllFieldNames
        {
            get
            {
                return "[mv_pk],[mv_Title],[mv_st_pk],[mv_Year],[mv_Description],[mv_Rating],[mv_UPC],[mv_DvdReleaseDate],[mv_Status],[mv_CreatedAt],[mv_CreatedBy],[mv_Version]";
            }
        }

        /// <summary>
        /// The name of the database that contains the table to which this business object is mapped.
        /// </summary>
        public override String Database
        {
            get
            {
                return "StrataFlix";
            }
        }

        private static string[] _PrimaryKeyFields = new string[] { "mv_pk" };
        /// <summary>
        /// Gets the field or fields that comprise the primary key for the business object.
        /// </summary>
        public override string[] PrimaryKeyFields
        {
            get
            {
                return _PrimaryKeyFields;
            }
        }

        /// <summary>
        /// The name of the table in the database to which this business object is mapped.
        /// </summary>
        public override String TableName
        {
            get
            {
                return "Movies";
            }
        }

        /// <summary>
        /// The schema of the table in the database to which this business object is mapped.
        /// </summary>
        public override String TableSchema
        {
            get
            {
                return "dbo";
            }
        }

        /// <summary>
        /// Creates and returns an array of DataColumns that contains the schema for the table.  This is used to prevent a round trip to the server to aquire the initial schema for the internal DataTable.
        /// </summary>
        protected override DataColumn[] CreateTableSchema()
        {
            return new DataColumn[] {
new DataColumn("mv_pk", typeof(System.Int32)),
new DataColumn("mv_Title", typeof(System.String)),
new DataColumn("mv_st_pk", typeof(System.Int64)),
new DataColumn("mv_Year", typeof(System.String)),
new DataColumn("mv_Description", typeof(System.String)),
new DataColumn("mv_Rating", typeof(System.Int32)),
new DataColumn("mv_UPC", typeof(System.String)),
new DataColumn("mv_DvdReleaseDate", typeof(System.DateTime)),
new DataColumn("mv_Status", typeof(System.Int32)),
new DataColumn("mv_CreatedAt", typeof(System.DateTime)),
new DataColumn("mv_CreatedBy", typeof(System.Int32)),
new DataColumn("mv_Version", typeof(System.Int32))};
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        protected void AddBrokenRule(MoviesBOFieldNames Field, string ErrorMessage)
        {
            base.AddBrokenRule(Field, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        protected new void AddBrokenRule(string FieldName, string ErrorMessage)
        {
            base.AddBrokenRule(FieldName, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        protected void AddBrokenRuleByKey(MoviesBOFieldNames Field, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(Field, ErrorMessageKey);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        protected new void AddBrokenRuleByKey(string FieldName, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(FieldName, ErrorMessageKey);
        }

        /// <summary>
        /// Gets a collection of the names for all fields that belong to this business object and map to the database.
        /// </summary>
        public override List<string> AllFieldsList
        {
            get
            {
                return _AllFieldsList;
            }
        }

        /// <summary>
        /// Gets a dictionary of the DbTypes for all fields that belong to this business object and map to the database.
        /// </summary>
        public override Dictionary<string, DbType> FieldDbTypes
        {
            get
            {
                return _FieldDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of all fields within this business object that map to the FieldNames enumeration for this business object.
        /// </summary>
        public override BusinessLayerFieldEnumDictionary FieldEnums
        {
            get
            {
                return _FieldEnums;
            }
        }

        /// <summary>
        /// Gets a dictionary of all of the lengths for all fields within this business object that map to a field in the database.
        /// </summary>
        public override Dictionary<string, int> FieldLengths
        {
            get
            {
                return _FieldLengths;
            }
        }

        /// <summary>
        /// Gets a dictionary of the native DbType (SqlDbType, OracleType, OleDbType, etc.) for all fields within this buisness object that map to a field in the database.
        /// </summary>
        public override Dictionary<string, int> FieldNativeDbTypes
        {
            get
            {
                return _FieldNativeDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of the security permission keys for each field in the business object.
        /// </summary>
        public override Dictionary<string, string> FieldPermissionKeys
        {
            get
            {
                return _FieldPermissionKeys;
            }
        }

        #endregion

        #region Field Properties

        /// <summary>
        /// Primary Key
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Primary Key"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 mv_pk
        {
            get
            {
                return (System.Int32)this.CurrentRow["mv_pk"];
            }
            set
            {
                this.CurrentRow["mv_pk"] = value;
            }
        }

        /// <summary>
        /// Movie Title
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Movie Title"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String mv_Title
        {
            get
            {
                return (System.String)this.CurrentRow["mv_Title"];
            }
            set
            {
                this.CurrentRow["mv_Title"] = value;
            }
        }

        /// <summary>
        /// Studio foreign key
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Studio foreign key"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int64 mv_st_pk
        {
            get
            {
                return (System.Int64)this.CurrentRow["mv_st_pk"];
            }
            set
            {
                this.CurrentRow["mv_st_pk"] = value;
            }
        }

        /// <summary>
        /// Year Released
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Year Released"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String mv_Year
        {
            get
            {
                return (System.String)this.CurrentRow["mv_Year"];
            }
            set
            {
                this.CurrentRow["mv_Year"] = value;
            }
        }

        /// <summary>
        /// Movie description
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Movie description"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String mv_Description
        {
            get
            {
                return (System.String)this.CurrentRow["mv_Description"];
            }
            set
            {
                this.CurrentRow["mv_Description"] = value;
            }
        }

        /// <summary>
        /// MPAA Rating
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("MPAA Rating"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public MovieRating mv_Rating
        {
            get
            {
                return (MovieRating)this.CurrentRow["mv_Rating"];
            }
            set
            {
                this.CurrentRow["mv_Rating"] = value;
            }
        }

        /// <summary>
        /// UPC code
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("UPC code"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String mv_UPC
        {
            get
            {
                return (System.String)this.CurrentRow["mv_UPC"];
            }
            set
            {
                this.CurrentRow["mv_UPC"] = value;
            }
        }

        /// <summary>
        /// DVD Release Date
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("DVD Release Date"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.DateTime mv_DvdReleaseDate
        {
            get
            {
                return (System.DateTime)this.CurrentRow["mv_DvdReleaseDate"];
            }
            set
            {
                this.CurrentRow["mv_DvdReleaseDate"] = value;
            }
        }

        /// <summary>
        /// DVD Status
        /// </summary>
        /// <remarks>
        /// Discontinued, available, etc.
        /// </remarks>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("DVD Status"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public MovieDVDStatus mv_Status
        {
            get
            {
                return (MovieDVDStatus)this.CurrentRow["mv_Status"];
            }
            set
            {
                this.CurrentRow["mv_Status"] = value;
            }
        }

        /// <summary>
        /// Time Stamp
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Time Stamp"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.DateTime mv_CreatedAt
        {
            get
            {
                return (System.DateTime)this.CurrentRow["mv_CreatedAt"];
            }
            set
            {
                this.CurrentRow["mv_CreatedAt"] = value;
            }
        }

        /// <summary>
        /// User Stamp
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("User Stamp"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 mv_CreatedBy
        {
            get
            {
                return (System.Int32)this.CurrentRow["mv_CreatedBy"];
            }
            set
            {
                this.CurrentRow["mv_CreatedBy"] = value;
            }
        }

        /// <summary>
        /// Row Version
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Row Version"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 mv_Version
        {
            get
            {
                return (System.Int32)this.CurrentRow["mv_Version"];
            }
            set
            {
                this.CurrentRow["mv_Version"] = value;
            }
        }

        #endregion

        #region Field Property Events

        #endregion

        #region Nested Types & Field Security

        /// <summary>
        /// Contains all of the field names that belong to the business object.
        /// </summary>
        public enum MoviesBOFieldNames
        {
            mv_pk,
            mv_Title,
            mv_st_pk,
            mv_Year,
            mv_Description,
            mv_Rating,
            mv_UPC,
            mv_DvdReleaseDate,
            mv_Status,
            mv_CreatedAt,
            mv_CreatedBy,
            mv_Version,
            CUSTOM_FIELD
        }

        /// <summary>
        /// Gets the System.Type of the enumeration that contains the field names for the business object.
        /// </summary>
        public override System.Type GetFieldEnumType()
        {
            return typeof(MoviesBOFieldNames);
        }

        /// <summary>
        /// Creates a new CheckFieldSecurityEventArgs object that can be used with this business object type.
        /// </summary>
        protected override CheckFieldSecurityEventArgsBase CreateNewFieldSecurityEventArgs(System.Enum Field, string CustomField, string PermissionKey, PermissionInfo Perm)
        {
            return new CheckFieldSecurityEventArgs<MoviesBOFieldNames>(Field, CustomField, PermissionKey, Perm);
        }

        /// <summary>
        /// Describes a method that will handle the CheckFieldScurity event.
        /// </summary>
        public delegate void CheckFieldSecurityEventHandler(object sender, CheckFieldSecurityEventArgs<MoviesBOFieldNames> e);

        /// <summary>
        /// Occurs when the business objects needs to check the security on a field.
        /// </summary>
        public event CheckFieldSecurityEventHandler CheckFieldSecurity;

        /// <summary>
        /// Raises the CheckFieldSecurity event.
        /// </summary>
        protected override void OnCheckFieldSecurity(CheckFieldSecurityEventArgsBase e)
        {
            if (this.CheckFieldSecurity != null)
            {
                this.CheckFieldSecurity(this, (CheckFieldSecurityEventArgs<MoviesBOFieldNames>)e);
            }
        }

        #endregion

        #region Item Property Implementation


        private static List<string> _AllFieldsList;
        private static Dictionary<string, DbType> _FieldDbTypes;
        private static BusinessLayerFieldEnumDictionary _FieldEnums;
        private static Dictionary<string, int> _FieldLengths;
        private static Dictionary<string, int> _FieldNativeDbTypes;
        private static Dictionary<string, string> _FieldPermissionKeys;

        /// <summary>
        /// Initializes the static members of the MoviesBO class.
        /// </summary>
        static MoviesBO()
        {
            //-- Create the new shared dictionary and populate it with an 
            //   instance of each property descriptor
            _PropertyDescriptors = new PropertyDescriptorDictionary(17);
            _PropertyDescriptors.Add("mv_pk", new FieldDescriptor(MoviesBOFieldNames.mv_pk, typeof(System.Int32)));
            _PropertyDescriptors.Add("mv_Title", new FieldDescriptor(MoviesBOFieldNames.mv_Title, typeof(System.String)));
            _PropertyDescriptors.Add("mv_st_pk", new FieldDescriptor(MoviesBOFieldNames.mv_st_pk, typeof(System.Int64)));
            _PropertyDescriptors.Add("mv_Year", new FieldDescriptor(MoviesBOFieldNames.mv_Year, typeof(System.String)));
            _PropertyDescriptors.Add("mv_Description", new FieldDescriptor(MoviesBOFieldNames.mv_Description, typeof(System.String)));
            _PropertyDescriptors.Add("mv_Rating", new FieldDescriptor(MoviesBOFieldNames.mv_Rating, typeof(MovieRating)));
            _PropertyDescriptors.Add("mv_UPC", new FieldDescriptor(MoviesBOFieldNames.mv_UPC, typeof(System.String)));
            _PropertyDescriptors.Add("mv_DvdReleaseDate", new FieldDescriptor(MoviesBOFieldNames.mv_DvdReleaseDate, typeof(System.DateTime)));
            _PropertyDescriptors.Add("mv_Status", new FieldDescriptor(MoviesBOFieldNames.mv_Status, typeof(MovieDVDStatus)));
            _PropertyDescriptors.Add("mv_CreatedAt", new FieldDescriptor(MoviesBOFieldNames.mv_CreatedAt, typeof(System.DateTime)));
            _PropertyDescriptors.Add("mv_CreatedBy", new FieldDescriptor(MoviesBOFieldNames.mv_CreatedBy, typeof(System.Int32)));
            _PropertyDescriptors.Add("mv_Version", new FieldDescriptor(MoviesBOFieldNames.mv_Version, typeof(System.Int32)));

            _AllFieldsList = new List<string>(12);
            _AllFieldsList.Add("mv_pk");
            _AllFieldsList.Add("mv_Title");
            _AllFieldsList.Add("mv_st_pk");
            _AllFieldsList.Add("mv_Year");
            _AllFieldsList.Add("mv_Description");
            _AllFieldsList.Add("mv_Rating");
            _AllFieldsList.Add("mv_UPC");
            _AllFieldsList.Add("mv_DvdReleaseDate");
            _AllFieldsList.Add("mv_Status");
            _AllFieldsList.Add("mv_CreatedAt");
            _AllFieldsList.Add("mv_CreatedBy");
            _AllFieldsList.Add("mv_Version");

            _FieldDbTypes = new Dictionary<string, DbType>(12);
            _FieldDbTypes.Add("mv_pk", DbType.Int32);
            _FieldDbTypes.Add("mv_Title", DbType.String);
            _FieldDbTypes.Add("mv_st_pk", DbType.Int64);
            _FieldDbTypes.Add("mv_Year", DbType.AnsiString);
            _FieldDbTypes.Add("mv_Description", DbType.String);
            _FieldDbTypes.Add("mv_Rating", DbType.Int32);
            _FieldDbTypes.Add("mv_UPC", DbType.AnsiString);
            _FieldDbTypes.Add("mv_DvdReleaseDate", DbType.DateTime);
            _FieldDbTypes.Add("mv_Status", DbType.Int32);
            _FieldDbTypes.Add("mv_CreatedAt", DbType.DateTime);
            _FieldDbTypes.Add("mv_CreatedBy", DbType.Int32);
            _FieldDbTypes.Add("mv_Version", DbType.Int32);

            _FieldEnums = new BusinessLayerFieldEnumDictionary(13);
            _FieldEnums.Add("mv_pk", MoviesBOFieldNames.mv_pk);
            _FieldEnums.Add("mv_Title", MoviesBOFieldNames.mv_Title);
            _FieldEnums.Add("mv_st_pk", MoviesBOFieldNames.mv_st_pk);
            _FieldEnums.Add("mv_Year", MoviesBOFieldNames.mv_Year);
            _FieldEnums.Add("mv_Description", MoviesBOFieldNames.mv_Description);
            _FieldEnums.Add("mv_Rating", MoviesBOFieldNames.mv_Rating);
            _FieldEnums.Add("mv_UPC", MoviesBOFieldNames.mv_UPC);
            _FieldEnums.Add("mv_DvdReleaseDate", MoviesBOFieldNames.mv_DvdReleaseDate);
            _FieldEnums.Add("mv_Status", MoviesBOFieldNames.mv_Status);
            _FieldEnums.Add("mv_CreatedAt", MoviesBOFieldNames.mv_CreatedAt);
            _FieldEnums.Add("mv_CreatedBy", MoviesBOFieldNames.mv_CreatedBy);
            _FieldEnums.Add("mv_Version", MoviesBOFieldNames.mv_Version);
            _FieldEnums.Add("CUSTOM_FIELD", MoviesBOFieldNames.CUSTOM_FIELD);

            _FieldLengths = new Dictionary<string, int>(12);
            _FieldLengths.Add("mv_pk", 4);
            _FieldLengths.Add("mv_Title", 1024);
            _FieldLengths.Add("mv_st_pk", 8);
            _FieldLengths.Add("mv_Year", 4);
            _FieldLengths.Add("mv_Description", -1);
            _FieldLengths.Add("mv_Rating", 4);
            _FieldLengths.Add("mv_UPC", 25);
            _FieldLengths.Add("mv_DvdReleaseDate", 8);
            _FieldLengths.Add("mv_Status", 4);
            _FieldLengths.Add("mv_CreatedAt", 8);
            _FieldLengths.Add("mv_CreatedBy", 4);
            _FieldLengths.Add("mv_Version", 4);

            _FieldNativeDbTypes = new Dictionary<string, int>(12);
            _FieldNativeDbTypes.Add("mv_pk", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("mv_Title", (int)System.Data.SqlDbType.NVarChar);
            _FieldNativeDbTypes.Add("mv_st_pk", (int)System.Data.SqlDbType.BigInt);
            _FieldNativeDbTypes.Add("mv_Year", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("mv_Description", (int)System.Data.SqlDbType.NVarChar);
            _FieldNativeDbTypes.Add("mv_Rating", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("mv_UPC", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("mv_DvdReleaseDate", (int)System.Data.SqlDbType.DateTime);
            _FieldNativeDbTypes.Add("mv_Status", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("mv_CreatedAt", (int)System.Data.SqlDbType.DateTime);
            _FieldNativeDbTypes.Add("mv_CreatedBy", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("mv_Version", (int)System.Data.SqlDbType.Int);

            _FieldPermissionKeys = new Dictionary<string, string>(12);

        }

        private static bool _AreCustomDescriptorsEvaluated = false;
        protected override bool AreCustomDescriptorsEvaluated
        {
            get
            {
                bool llReturn = _AreCustomDescriptorsEvaluated;
                _AreCustomDescriptorsEvaluated = true;
                return llReturn;
            }
        }

        private static PropertyDescriptorDictionary _PropertyDescriptors;
        protected override PropertyDescriptorDictionary PropertyDescriptors
        {
            get
            {
                return _PropertyDescriptors;
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of fields within the MoviesBO business object.
        /// </summary>
        private class FieldDescriptor :
        MicroFour.StrataFrame.Business.FieldPropertyDescriptor<MoviesBOFieldNames>
        {
            public FieldDescriptor(MoviesBOFieldNames field, Type fieldType) :
                base(field, fieldType) { }
            private static Type _ComponentType = typeof(MoviesBO);
            public override object GetValue(object component)
            {
                switch (this.Field)
                {
                    case MoviesBOFieldNames.mv_pk:
                        return ((MoviesBO)component).mv_pk;
                    case MoviesBOFieldNames.mv_Title:
                        return ((MoviesBO)component).mv_Title;
                    case MoviesBOFieldNames.mv_st_pk:
                        return ((MoviesBO)component).mv_st_pk;
                    case MoviesBOFieldNames.mv_Year:
                        return ((MoviesBO)component).mv_Year;
                    case MoviesBOFieldNames.mv_Description:
                        return ((MoviesBO)component).mv_Description;
                    case MoviesBOFieldNames.mv_Rating:
                        return ((MoviesBO)component).mv_Rating;
                    case MoviesBOFieldNames.mv_UPC:
                        return ((MoviesBO)component).mv_UPC;
                    case MoviesBOFieldNames.mv_DvdReleaseDate:
                        return ((MoviesBO)component).mv_DvdReleaseDate;
                    case MoviesBOFieldNames.mv_Status:
                        return ((MoviesBO)component).mv_Status;
                    case MoviesBOFieldNames.mv_CreatedAt:
                        return ((MoviesBO)component).mv_CreatedAt;
                    case MoviesBOFieldNames.mv_CreatedBy:
                        return ((MoviesBO)component).mv_CreatedBy;
                    case MoviesBOFieldNames.mv_Version:
                        return ((MoviesBO)component).mv_Version;
                    default:
                        throw new BusinessLayerException("Field not supported.");
                }
            }
            public override void SetValue(object component, object value)
            {
                switch (this.Field)
                {
                    case MoviesBOFieldNames.mv_pk:
                        ((MoviesBO)component).mv_pk = (System.Int32)value;
                        break;
                    case MoviesBOFieldNames.mv_Title:
                        ((MoviesBO)component).mv_Title = (System.String)value;
                        break;
                    case MoviesBOFieldNames.mv_st_pk:
                        ((MoviesBO)component).mv_st_pk = (System.Int64)value;
                        break;
                    case MoviesBOFieldNames.mv_Year:
                        ((MoviesBO)component).mv_Year = (System.String)value;
                        break;
                    case MoviesBOFieldNames.mv_Description:
                        ((MoviesBO)component).mv_Description = (System.String)value;
                        break;
                    case MoviesBOFieldNames.mv_Rating:
                        ((MoviesBO)component).mv_Rating = (MovieRating)value;
                        break;
                    case MoviesBOFieldNames.mv_UPC:
                        ((MoviesBO)component).mv_UPC = (System.String)value;
                        break;
                    case MoviesBOFieldNames.mv_DvdReleaseDate:
                        ((MoviesBO)component).mv_DvdReleaseDate = (System.DateTime)value;
                        break;
                    case MoviesBOFieldNames.mv_Status:
                        ((MoviesBO)component).mv_Status = (MovieDVDStatus)value;
                        break;
                    case MoviesBOFieldNames.mv_CreatedAt:
                        ((MoviesBO)component).mv_CreatedAt = (System.DateTime)value;
                        break;
                    case MoviesBOFieldNames.mv_CreatedBy:
                        ((MoviesBO)component).mv_CreatedBy = (System.Int32)value;
                        break;
                    case MoviesBOFieldNames.mv_Version:
                        ((MoviesBO)component).mv_Version = (System.Int32)value;
                        break;
                    default:
                        throw new BusinessLayerException("Field not supported.");
                }
            }
            public override Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        #endregion

    }

}
